/**********
* File: CDGL_IDirect3DSurface9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DSurface9. 
					 This class is equivalent to IDirect3DSurface9 interface in Direct3D9. The IDirect3DSurface9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Yogesh Kini

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 26Oct04

* Change History (Most Recent First):
 
* Modified by  : Bala 

**********/
#ifndef _CDGL_IDIRRECT3DSURFACE_H_
#define _CDGL_IDIRRECT3DSURFACE_H_

#include "d3d9.h"

#ifndef LIB_CHANGES
#include "OZone/ITexture.h"
# include "OZone/IRenderTexture.h"
#else
#include "ITexture.h"
#include "IRenderTexture.h"
#endif	// LIB_CHANGES

class CDGL_IDirect3DSurface9 : public IDirect3DSurface9
{
	public:
	
		CDGL_IDirect3DSurface9(IDirect3DDevice9 *pDevice, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE mstype = D3DMULTISAMPLE_NONE, BOOL Lockable = true, ITexture ozTexture = 0);
		~CDGL_IDirect3DSurface9();
		
		//! IUnknown methods
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();
		
		//! IDirect3DResource9 methods
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT SetPrivateData( REFGUID refguid,CONST void* pData,DWORD SizeOfData,DWORD Flags);
		HRESULT GetPrivateData( REFGUID refguid,void* pData,DWORD* pSizeOfData);
		HRESULT FreePrivateData( REFGUID refguid);
		DWORD   SetPriority( DWORD PriorityNew);
		DWORD   GetPriority();
		void	PreLoad();
		D3DRESOURCETYPE GetType();
		
		//! IDirect3DSurface9 methods
		HRESULT GetContainer ( REFIID riid,void** ppContainer);
		HRESULT GetDC ( HDC *phdc);
		HRESULT GetDesc( D3DSURFACE_DESC *pDesc);
	
		HRESULT LockRect ( D3DLOCKED_RECT* pLockedRect,CONST RECT* pRect,DWORD Flags);

	
		HRESULT UnlockRect();
		HRESULT ReleaseDC( HDC hdc);
		
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• Additional methods •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|
	
		// Accessors for local data
		void	SetLocaldata(void* in_pData);
		void *	GetLocalData();
		
		
				
		// Sharathchandra RenderTargets : Begin
 		void  SetRenderTextureInfo(IRenderTexture  inTex);


		ITexture  GetParentOZoneTexture() { return mParentTexture;}
		
		IRenderTexture GetRenderTextureInfo() { return mRenderTexture; }
		 	//anand.cs@robosoftin.com 
 			//fix from iphone
		bool mbIsSurfaceSubmitted;
		//till here
		// Rendertargets : End 
		
		

	protected:
		IDirect3DDevice9 *		m_pDevice;		
		int						m_lWidth;
		int						m_lHeight;
		D3DFORMAT				m_Format;
		D3DMULTISAMPLE_TYPE		m_mstype;
		int						m_lRefCount;
		void			*		m_pvLocalData; 
		RECT					m_RectLock;
		DWORD					m_dwFlagsLock;	
	
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• SMARTDX •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|
	
		ITexture			  mParentTexture;
		
		IRenderTexture		mRenderTexture; // sharathchandra rendertexture 

};

#endif  //_CDGL_IDIRRECT3DSURFACE_H_